### 过程数据

上行数据

| **上行数据17字节** |
|---|
| **名称** | **含义** | **取值范围** | **数据类型** | **长度** |
| E0 Input CH0 (Latch) | 编码器探针输入信号通道0 | 0：无信号输入 | bool | 1位 |
| 1：有信号输入 |
| E0 Input CH1 (Latch) | 编码器探针输入信号通道1 | 0：无信号输入 | bool | 1位 |
| 1：有信号输入 |
| E0 Input CH2 | 编码器普通输入信号通道2 | 0：无信号输入 | bool | 1位 |
| 1：有信号输入 |
| E0 Latched Flag CH0 | 编码器探针输入通道0锁存完成标志位 | 0：1-&gt;0锁存一次，翻转一次 | bool | 1位 |
| 1：0-&gt;1锁存一次，翻转一次 |
| E0 Latched Flag CH1 | 编码器探针输入通道1锁存完成标志位 | 0：1-&gt;0锁存一次，翻转一次 | bool | 1位 |
| 1：0-&gt;1锁存一次，翻转一次 |
| E0 Count Value | 编码器计数值 | 0~2^32-1 | unsigned32 | 4字节 |
| E0 Latch Value CH0 | 编码器探针输入通道0锁存值 | 0~2^32-1 | unsigned32 | 4字节 |
| E0 Latch Value CH1 | 编码器探针输入通道1锁存值 | 0~2^32-1 | unsigned32 | 4字节 |
| E0 Speed | 编码器速度 | -2^31~2^31-1 | signed32 | 4字节 |



**上行数据说明：**

- **编码器探针输入信号通道E0 Input CH0/CH1 (Latch)**  
    编码器配2路探针输入通道，表明对应的探针输入通道输入信号的有无。  
    探针输入通道锁存功能未开启时，可作为普通数字量输入通道使用。

- **编码器普通输入信号通道E0 Input CH2/CH3**  
    每路编码器配1路普通数字量输入通道，表明对应的DI通道输入信号的有无。

- **编码器探针输入通道锁存完成标志位E0 Latched Flag CH0/CH1**  
    1路编码器配2路探针输入通道，探针输入通道完成一次锁存后，标志位将发生0-&gt;1或1-&gt;0的翻转。  
    例1：编码器0探针输入通道1锁存完成标志位为0，完成一次锁存后，标志位变为1，再完成一次锁存后，标志位变为0。

- **编码器计数值E0 Count Value**  
    编码器计数值为对应编码器当前的计数值大小，数值范围为0~2^32-1。

- **编码器探针输入通道锁存值E0 Latch Value CH0/CH1**  
    每路编码器配备2路探针输入通道，通过对探针输入通道输入满足设定条件的信号，可以快速锁存对应编码器当前的计数值，因此锁存值的数值范围与计数值一样，数值范围为0~2^32-1。

- **编码器速度E0 Speed**   
    编码器速度为编码器输入通道的脉冲速度大小，数值范围为-2^31~2^31-1。

下行数据

| **下行指令10字节** |
|---|
| **名称** | **含义** | **取值范围** | **数据类型** | **长度** |
| E0 Enable | 编码器计数使能 | 0：失能 | bool | 1位bit0 |
| 1：使能 |
| E0 Z Phase Clear Enable | 编码器Z相清零使能 | 0：失能 | bool | 1位bit1 |
| 1：使能 |
| E0 Count Clear | 编码器计数值清零 | 0：失能 | bool | 1位bit2 |
| 1：使能 |
| E0 Compare Output CH0 Enable | 编码器比较输出通道0使能 | 0：失能 | bool | 1位bit3 |
| 1：使能 |
| E0 Compare Output CH1 Enable | 编码器比较输出通道1使能 | 0：失能 | bool | 1位bit4 |
| 1：使能 |
| E0 Compare Output CH0 Direction | 编码器比较输出通道0比较方向 | 0：递减比较 | bool | 1位bit5 |
| 1：递增比较 |
| E0 Compare Output CH1 Direction | 编码器比较输出通道1比较方向 | 0：递减比较 | bool | 1位bit6 |
| 1：递增比较 |
| E0 Compare Output CH0 Mode | 编码器比较输出通道0触发模式 | 0：单次触发 | bool | 1位bit7 |
| 1：重复触发 |
| E0 Compare Output CH1 Mode | 编码器比较输出通道1触发模式 | 0：单次触发 | bool | 1位bit0 |
| 1：重复触发 |
| E0 Output CH0 (Compare) | 编码器输出通道0（比较输出） | 0：输出高电平24V | bool | 1位bit1 |
| 1：输出低电平0V |
| E0 Output CH1 (Compare) | 编码器输出通道1（比较输出） | 0：输出高电平24V | bool | 1位bit2 |
| 1：输出低电平0V |
| E0 Output CH2 | 编码器输出通道2（普通输出） | 0：输出高电平24V | bool | 1位bit3 |
| 1：输出低电平0V |
| E0 Output CH3 | 编码器输出通道3（普通输出） | 0：输出高电平24V | bool | 1位bit4 |
| 1：输出低电平0V |
| E0 Latch CH0 Enable | 编码器探针输入通道0锁存使能 | 0：失能 | bool | 1位bit5 |
| 1：使能 |
| E0 Latch CH1 Enable | 编码器探针输入通道1锁存使能 | 0：失能 | bool | 1位bit6 |
| 1：使能 |
| E0 Compare Value CH0 | 编码器比较输出通道0设定值 | 0~2^32-1 | unsigned32 | 4字节 |
| E0 Compare Value CH1 | 编码器比较输出通道1设定值 | 0~2^32-1 | unsigned32 | 4字节 |





下行数据说明：

- **编码器计数使能E0 Enable**  
    编码器计数使能置为0则为失能，置为1则为使能。

- **编码器Z相清零使能E0 Z Phase Clear Enable**  
    编码器Z相清零使能置为0则为失能，置为1则为使能。  
    Z相清零使能后，通过检测编码器的Z相信号，来对当前计数值进行清零。编码器每转动一圈，会产生一个Z相脉冲，计数值清零一次。  
    编码器的物理分辨率为编码器转动一圈所输出的脉冲数量，计数倍率×物理分辨率为单圈计数的最大值。Z相清零功能开启，计数值递增或递减时，编码器每转动一圈，计数值清零一次。

- **编码器计数值清零E0 Count Clear**  
    边沿控制，当检测到该位从0置1时，对应的编码器计数值清零。如果设置了编码器计数初始值时，计数值同样置为0。

- **编码器比较输出--通道使能E0 Compare Output CH0/CH1 Enable**  
    编码器比较输出使能置为0则为失能，置为1则为使能。  
    比较输出通道功能未使能时，可作为普通数字量输出通道使用。  
    注意：比较输出使能前必须确保比较输出通道未输出，否则输出状态下使能比较输出会导致一直有输出。

- **编码器比较输出--通道比较方向E0 Compare Output CH0/CH1 Direction**  
    编码器比较输出通道比较方向置为0为递减比较，即计数值从大到小的方向；置为1为递增比较，即计数值从小到大的方向。

- **编码器比较输出--通道触发模式E0 Compare Output CH0/CH1 Mode**  
    编码器比较输出通道触发模式可设置为：0（单次触发），1（重复触发）。  
    单次触发即比较输出功能使能后，计数值满足条件时触发一次脉冲输出，之后不再比较，再次触发比较输出需重新使能比较输出功能。  
    重复触发即比较输出功能使能后，计数值满足条件时触发一次脉冲输出，之后会立即开始下一次比较，但在比较输出脉冲时间内不会再次重新开始一段时间的脉冲输出。在比较输出触发一段时间的脉冲完成后，满足比较输出条件将会再次触发脉冲输出。

- **编码器输出通道（比较输出）E0 Output CH0/CH1 (Compare)**  
    比较输出通道功能未使能时，可作为普通数字量输出通道使用。数字量通道输出（NPN型输出）：置“0”则输出高电平24V，置“1”则输出低电平0V。  
    比较输出成立时，将翻转此引脚电平，故可通过先设定该位再使能比较输出，来设置比较输出对应的无/有效电平。

- **编码器输出通道（普通输出）E0 Output CH2/CH3**  
    数字量通道输出（NPN型输出）：置“0”则输出高电平24V，置“1”则输出低电平0V。

- **编码器探针输入通道锁存使能E0 Latch CH0/CH1 Enable**  
    编码器输入锁存通道使能标志位设置为1则锁存功能使能，设置为0则锁存功能失能。

- **编码器比较输出通道设定值E0 Compare Output CH0/CH1 Set Value**  
    编码器比较输出通道设定值与编码器计数范围一致，范围为0~2^32-1。  
    比较输出功能使能后，模块会对比当前计数值与设定值是否一致。当比较方向与比较设定值均一致时，对应比较输出通道会输出一个时间可调的脉冲。

---

### 配置参数定义

模块配置一共有12个参数，如下表所示。注：配置参数均在编码器下次使能时生效。

| **功能** | **参数名** | **取值范围** | **默认值** |
|---|---|---|---|
| 编码器0脉冲模式 | Encoder0 Pulse Mode | 0：ABZ（AB正交） | 0 |
| 1：Pul+Dir（方向脉冲） |
| 2：CW/CCW（双脉冲） |
| 编码器0滤波 | Encoder0 Filter Level | 0~15级 | 7 |
| 编码器0计数倍率 | Encoder0 Count Multiple | MUL\_1、2、4（只在AB正交模式下生效） | MUL\_1 |
| 编码器0计数范围 | Encoder0 Count Range | 0：2^32（0~2^32-1） | 0 |
| 1：Resolution×Multiple（0~环形计数分辨率×计数倍率-1，只在AB正交模式下生效） |
| 编码器0环形计数分辨率 | Encoder0 Count Resolution | 1~65535 | 1 |
| 编码器0计数方向 | Encoder0 Count Direction | 0：Forward（正向） | 0 |
| 1：Backward（反向） |
| 编码器0计数初始值 | Encoder0 Count Initial Value | 0~2^32-1 | 0 |
| 编码器0探针模式 | Encoder0 Latch Trigger Mode | 0：CH0 Single，CH1 Single通道0单次、通道1单次 | 0 |
| 1：CH0 Repeat，CH1 Single通道0重复、通道1单次 |
| 2：CH0 Single，CH1 Repeat通道0单次、通道1重复 |
| 3：CH0 Repeat，CH1 Repeat通道0重复、通道1重复 |
| 编码器0探针触发边沿 | Encoder0 Latch Trigger Edge | 0：CH0 Raising，CH1 Raising通道0上升沿、通道1上升沿 | 0 |
| 1：CH0 Falling，CH1 Raising通道0下降沿、通道1上升沿 |
| 2：CH0 Raising，CH1 Falling通道0上升沿、通道1下降沿 |
| 3：CH0 Falling，CH1 Falling通道0下降沿、通道1下降沿 |
| 编码器0比较输出通道0脉冲时间 | Encoder0 Compare Output CH0 Keep Time | 0~65535（单位：ms） | 10 |
| 编码器0比较输出通道1脉冲时间 | Encoder0 Compare Output CH1 Keep Time | 0~65535（单位：ms） | 10 |
| 掉电存储使能 | Power Down Storage | 0：OFF关闭 | 1 |
| 1：ON开启 |

---

### 编码器计数功能

编码器计数参数包括**编码器脉冲模式、滤波、计数倍率、计数范围、环形计数分辨率、计数方向和计数初始值**7项参数。

- 编码器脉冲模式：编码器计数支持的输入脉冲模式有AB正交模式，方向脉冲模式和CW/CCW模式。
- 编码器滤波：编码器滤波三种脉冲模式下均有效，滤波共16个等级（0~15），等级0表示无滤波，等级15表示滤波程度最大。编码器滤波参数默认为等级7，可根据需要进行配置。
- 编码器计数倍率：编码器计数倍率仅在AB正交脉冲模式下生效。
- 编码器计数范围：编码器的计数范围可以设置为0~2^32-1或0~环形计数分辨率×计数倍率-1，前者适用于绝大多数情况，后者适用于编码器无Z相信号，但依然需要用于单圈计数的情况。
- 编码器环形计数分辨率：环形计数分辨率用作设定编码器的计数范围，设置范围为0~65535。

注意：此处的环形计数分辨率不同于编码器本身的物理分辨率。当分辨率设置为0时，计数范围设置为1即0~环形计数分辨率×计数倍率-1，环形计数不生效。

- 编码器计数方向：编码器计数方向默认为0为正向计数；置为1时在编码器重新使能后，将对编码器进行反向计数。
- 编码器计数初始值：编码器的计数初始值支持配置，在编码器重新使能后自动生效。计数初始值的设置范围为0~2^32-1。注意：当掉电存储功能使能时，计数初始值无效，编码器计数初始值均为0。当计数初始值大于环形计数最大值时，环形计数不生效。

例1：编码器0脉冲模式置为AB正交模式，编码器的计数范围选择0~环形计数分辨率×计数倍率-1，环形计数分辨率设置为50000，计数倍率为4，计数方向为正向，计数初始值为0，则计数范围为0~200000。模块接入一个物理分辨率为1000的编码器，开始计数后，计数值从0开始递增，编码器转动一圈计数值1000×4＝4000，达到200000后回到0继续计数。

---

### 探针功能

探针功能参数包括探针模式和探针触发边沿两项参数。编码器配备2路探针输入通道，通过对探针输入通道输入对应信号，可以锁存对应编码器的计数值。

- 探针模式：探针模式参数可配置编码器每个探针功能通道为单次/连续模式。

探针功能通道配置为单次模式，则探针功能使能后，通道输入满足设定条件的信号时，可锁存一次计数值；后续再次输入满足设定条件的信号时，不再进行锁存，除非重新使能该探针功能通道。

探针功能通道配置为连续模式，则探针功能使能后，每次通道输入满足设定条件的信号，均可锁存一次计数值，即可多次锁存计数值。

- 探针触发边沿：通过探针触发边沿参数可配置编码器每个探针功能通道为上升沿/下降沿触发。编码器的两个探针功能通道锁存触发信号可单独配置，锁存数值可以单独显示。

探针输入通道通过COM端兼容PNP/NPN信号。当COM端接入0V时，输入信号为PNP型，输入高电平24V信号有效，输入低电平0V信号无效；当COM端接入24V时，输入信号为NPN型，输入低电平0V信号有效，输入高电平24V信号无效。

上升沿触发表示探针输入通道从无效信号到有效信号触发，下降沿触发表示从有效信号到无效信号触发。

---

### 比较输出功能

比较输出功能通过对比较输出通道使能、比较输出设定值、比较方向、单次/重复触发模式和比较输出通道脉冲时间进行配置，当编码器的计数值达到设定值且满足比较方向时，对应的比较输出通道会输出一个时间可调的脉冲，可调的时间即为比较输出脉冲时间。比较输出功能的脉冲输出响应速度可达10us级别。

比较输出功能配置参数包括编码器比较输出通道脉冲时间，可配置的时间范围为0~65535ms。

编码器配备2路比较输出通道，比较输出通道使能、比较输出设定值、比较方向和单次/重复触发模式均可在下行数据中进行设置。当比较输出通道功能未使能时，比较输出通道可作为普通数字量输出使用。

例1：编码器0的比较输出通道1作为普通数字量输出时输出值置为0（NPN型输出，此时输出为24V），通道指示灯为熄灭状态。

编码器0比较输出通道1设定值设置为1000，比较方向设置为递增比较，比较输出触发模式为单次触发，比较输出通道1脉冲时间配置为5s，比较输出通道1功能使能后，当编码器0的计数值从小到大（满足比较方向）达到1000时，比较输出通道1将作为比较输出通道输出，状态发生翻转，由原本的高电平输出变为低电平输出，脉冲输出时间为5s，通道指示灯将常亮5s。5s后恢复高电平输出，通道指示灯熄灭。计数值再次满足比较输出设定值和比较方向时，由于比较输出触发模式为单次触发，比较输出通道无反应。

例2：编码器0的比较输出通道1作为普通数字量输出时输出值置为1（NPN型输出，此时输出为0V），通道指示灯为常亮状态。

编码器0比较输出通道1设定值设置为1000，比较方向设置为递减比较，比较输出触发模式为重复触发，比较输出通道1脉冲时间配置为5s，比较输出通道1功能使能后，当编码器0的计数值从小到大（不满足比较方向）达到1000时，比较输出通道1无反应；当编码器0的计数值从大到小（满足比较方向）达到1000时，比较输出通道将作为比较输出通道输出，状态发生翻转，由原本的低电平输出变为高电平输出，脉冲输出时间为5s，通道指示灯将熄灭5s。5s后恢复低电平输出，通道指示灯常亮。

比较输出触发模式为重复触发，脉冲输出时间5s内计数值再次满足比较输出设定值和比较方向时，比较输出通道不会改变脉冲输出状态，仍继续完成5s脉冲输出。5s后再次满足比较条件时，状态将再次发生翻转，由原本的高电平输出变为低电平输出，脉冲输出时间为5s，通道指示灯将熄灭5s。比较输出重复触发以此类推。

---

### 掉电存储功能

掉电存储使能参数开启时，在系统断电情况下可存储编码器计数值。默认为1为掉电存储功能开启，置为0则掉电存储功能关闭。

当掉电存储功能使能时，编码器计数初始值无效，编码器计数初始值均为0。